/****** Object:  StoredProcedure [dbo].[P_EST_FECHA_PROC_MOV_ALL]    Script Date: 06/16/2012 13:50:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_FECHA_PROC_MOV_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_ALL]
GO
--Adicionar step no job de fechamento de estoque
--Rodar toda vira de mes para analise do custo medio
--MES, ANO, FILIAL,FORCA FECHA,PRODUTO,FILIAL INI, IGNORA ATUA
--EXECUTE P_EST_FECHA_PROC_MOV_ALL 07, 2015,0,0,0
--versao 2381

CREATE PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_ALL]( @MES INT=NULL, 
												   @ANO INT=NULL,
												   @CD_FILIAL_PAR INT=0, 								
												   @CD_PROD INT=0,
												   @FILIAL_INICIO INT=0)  AS
	DECLARE @DT_PROC DATETIME
	DECLARE @CD_FILIAL AS INT
	DECLARE @AGORA DATETIME
	
	SET NOCOUNT ON
	IF @ANO IS NULL OR @MES IS NULL
		begin
			SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
		end
	
	SET @DT_PROC = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
	
	DECLARE cFilialCustoMedioAll CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE 
		CD_EMP = 1  
		AND CD_FILIAL>=@FILIAL_INICIO 
		AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
		AND STS_FILIAL=0
	ORDER BY CD_FILIAL
	
	OPEN cFilialCustoMedioAll
	FETCH NEXT FROM cFilialCustoMedioAll INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
		PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
		--Colocando o produto na pendencia de geracao de custo medio a partir da data escolhida
		INSERT INTO EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
	  (CD_EMP,
	  CD_FILIAL,
	  CD_PROD,
	  DT_PROC,
	  DT_CAD,
	  DT_PROC_ATUAL)
		SELECT
			EST_PROD_CPL.CD_EMP ,
			EST_PROD_CPL.CD_FILIAL,
			EST_PROD_CPL.CD_PROD,
			@DT_PROC,
			GETDATE(),
			null
		FROM
			EST_PROD_CPL 
			LEFT JOIN EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p ON
			EST_PROD_CPL.CD_EMP = p.CD_EMP AND
			EST_PROD_CPL.CD_FILIAL = p.CD_FILIAL AND
			EST_PROD_CPL.CD_PROD = p.CD_PROD 
			
			inner  JOIN EST_PROD pr ON
			EST_PROD_CPL.CD_EMP = pr.CD_EMP AND
			EST_PROD_CPL.CD_PROD = pr.CD_PROD 
			and pr.sts_prod <>1
		WHERE
			EST_PROD_CPL.CD_EMP =1
			AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
			AND EST_PROD_CPL.STS_PROD <> 1
			AND EST_PROD_CPL.CD_PROD = CASE WHEN @CD_PROD =0 THEN EST_PROD_CPL.CD_PROD ELSE @CD_PROD END
			AND p.CD_PROD IS NULL
		
		--Alterando apenas processamento maior que a data solicitada para processamento
		UPDATE
			EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
		SET 
			DT_PROC=@DT_PROC,
			DT_CAD=GETDATE()
		WHERE
			DT_PROC >@DT_PROC
			AND CD_EMP = 1
			AND CD_FILIAL = @CD_FILIAL
			AND CD_PROD = CASE WHEN @CD_PROD =0 THEN CD_PROD ELSE @CD_PROD END
			
		--Alterando apenas processamento maior que a data solicitada para processamento
		UPDATE
			EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
		SET 
			DT_PROC_ATUAL=NULL
		WHERE	
			NOT DT_PROC_ATUAL IS NULL
			
		FETCH NEXT FROM  cFilialCustoMedioAll INTO @CD_FILIAL 
	END
CLOSE cFilialCustoMedioAll
DEALLOCATE cFilialCustoMedioAll